﻿using Microsoft.Xrm.Sdk;
using System;

namespace MCSHelperClass
{
    public class MCSHelper
    {
        #region Private Fields
        private Entity _thisEntity;

        private Entity _preEntity;
        #endregion

        #region Constructor
        public MCSHelper(Entity thisEntity, Entity preEntity)
        {
            _thisEntity = thisEntity;

            _preEntity = preEntity;
        }

        public MCSHelper()
        {
        }
        #endregion

        #region Public Methods
        public Entity setThisEntity
        {
            set { _thisEntity = value; }
        }

        public Entity setPreEntity
        {
            set { _preEntity = value; }
        }

        public bool getBoolValue(string attributeLogicalName)
        {
            if (_thisEntity.Attributes.Contains(attributeLogicalName))
            {
                return (bool)_thisEntity[attributeLogicalName];
            }

            if (_preEntity.Attributes.Contains(attributeLogicalName))
            {
                return (bool)_preEntity[attributeLogicalName];
            }

            return new bool();
        }

        public int getIntValue(string attributeLogicalName)
        {
            if (_thisEntity.Attributes.Contains(attributeLogicalName))
            {
                return (int)_thisEntity[attributeLogicalName];
            }

            if (_preEntity.Attributes.Contains(attributeLogicalName))
            {
                return (int)_preEntity[attributeLogicalName];
            }

            return int.MinValue;
        }
        public string getStringValue(string attributeLogicalName)
        {
            if (_thisEntity.Attributes.Contains(attributeLogicalName))
            {
                return _thisEntity[attributeLogicalName].ToString();
            }

            if (_preEntity.Attributes.Contains(attributeLogicalName))
            {
                return _preEntity[attributeLogicalName].ToString();
            }

            return null;
        }
        public DateTime getDateTimeValue(string attributeLogicalName)
        {
            if (_thisEntity.Attributes.Contains(attributeLogicalName))
            {
                return (DateTime)_thisEntity[attributeLogicalName];
            }

            if (_preEntity.Attributes.Contains(attributeLogicalName))
            {
                return (DateTime)_preEntity[attributeLogicalName];
            }

            return DateTime.MinValue;
        }

        public object getObject(string attributeLogicalName)
        {
            if (_thisEntity.Attributes.Contains(attributeLogicalName))
            {
                return _thisEntity[attributeLogicalName];
            }

            if (_preEntity.Attributes.Contains(attributeLogicalName))
            {
                return _preEntity[attributeLogicalName];
            }

            return null;
        }

        public string getStringOptionSetValue(string attributeLogicalName)
        {
            
            if (_thisEntity.FormattedValues.Contains(attributeLogicalName))
            {
                return _thisEntity.FormattedValues[attributeLogicalName].ToString();
            }

            if (_preEntity.FormattedValues.Contains(attributeLogicalName))
            {
                return _preEntity.FormattedValues[attributeLogicalName].ToString();
            }

            return null;
        }

        public int getOptionSetValue(string attributeLogicalName)
        {
            OptionSetValue myOpt;

            if (_thisEntity.Attributes.Contains(attributeLogicalName))
            {
                myOpt = (OptionSetValue)_thisEntity[attributeLogicalName];

                return myOpt.Value;
            }

            if (_preEntity.Attributes.Contains(attributeLogicalName))
            {
                myOpt = (OptionSetValue)_preEntity[attributeLogicalName];

                return myOpt.Value;
            }

            return 0;
        }

        public string getEntRefName(string attributeLogicalName)
        {
            EntityReference myRef;

            if (_thisEntity.Attributes.Contains(attributeLogicalName))
            {
                myRef = (EntityReference)_thisEntity[attributeLogicalName];

                return myRef.Name;
            }
            if (_preEntity.Attributes.Contains(attributeLogicalName))
            {
                myRef = (EntityReference)_preEntity[attributeLogicalName];

                return myRef.Name;
            }

            return null;
        }

        public Guid getEntRefID(string attributeLogicalName)
        {
            EntityReference myRef;

            if (_thisEntity.Attributes.Contains(attributeLogicalName))
            {
                myRef = (EntityReference)_thisEntity[attributeLogicalName];

                return myRef.Id;
            }
            if (_preEntity.Attributes.Contains(attributeLogicalName))
            {
                myRef = (EntityReference)_preEntity[attributeLogicalName];

                return myRef.Id;
            }

            return Guid.Empty;
        }

        public string getEntRefType(string attributeLogicalName)
        {
            EntityReference myRef;

            if (_thisEntity.Attributes.Contains(attributeLogicalName))
            {
                myRef = (EntityReference)_thisEntity[attributeLogicalName];

                return myRef.LogicalName;
            }

            if (_preEntity.Attributes.Contains(attributeLogicalName))
            {
                myRef = (EntityReference)_preEntity[attributeLogicalName];

                return myRef.LogicalName;
            }

            return null;
        }
        #endregion
    }
}
